/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.WormLarge;
import OreSpawn.entities.WormMedium;
import OreSpawn.entities.WormSmall;
import dangerzone.DangerZone;
import dangerzone.Explosion;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class DoomWorm
extends EntityLiving {
    public double[] lposx = new double[100];
    public double[] lposy = new double[100];
    public double[] lposz = new double[100];
    public double[] rotpitch = new double[100];
    public double[] rotroll = new double[100];
    public double[] rotyaw = new double[100];
    public long lasttime = 0L;
    public int backoff = 0;
    public int inarow = 0;

    public DoomWorm(World w) {
        super(w);
        this.maxrenderdist = 325;
        this.height = 4.5f;
        this.width = 4.5f;
        this.uniquename = "OreSpawn:Doom Worm";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(3000.0f);
        this.setHealth(3000.0f);
        this.setDefense(3.5f);
        this.setAttackDamage(250.0f);
        this.searchDistance = 220.0f;
        this.attackRange = 6.0f;
        this.movefrequency = 15;
        this.setExperience(5000);
        this.canSwim = false;
        this.takesFallDamage = false;
        this.ignoreCollisions = true;
        this.setCanDespawn(false);
        this.temperament = 1;
        this.enable_hostile = false;
        this.daytimespawn = false;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = false;
        this.tower_defense_enable = false;
        this.foodsearchDistance = 48;
        if (w != null) {
            this.setVarFloat(10, w.rand.nextFloat() * 360.0f);
            this.setVarFloat(11, this.rotation_yaw);
        }
        this.always_draw = true;
    }

    public void init() {
        super.init();
        double mx = (float)Math.sin(Math.toRadians(this.rotation_yaw)) * 0.75f;
        double mz = (float)Math.cos(Math.toRadians(this.rotation_yaw)) * 0.75f;
        mx /= 2.0;
        mz /= 2.0;
        int i = 0;
        while (i < 100) {
            this.lposx[i] = this.posx - mx * (double)i * 1.5;
            this.lposy[i] = this.posy + (double)((float)Math.sin(Math.toRadians(i * 10 + 180)) * 4.0f);
            this.lposz[i] = this.posz - mz * (double)i * 1.5;
            this.rotpitch[i] = 0.0;
            this.rotroll[i] = 0.0;
            this.rotyaw[i] = this.rotation_yaw;
            ++i;
        }
    }

    public boolean isFoodItem(int iid) {
        return iid == OreSpawnMain.wormfood.itemID;
    }

    public void doEatDroppedFood(EntityBlockItem eb) {
        super.doEatDroppedFood(eb);
        this.heal(50.0f);
        this.removeAllEffects();
    }

    public void doAttack(Entity victim) {
        if (victim == null) {
            return;
        }
        if (victim.has_inventory) {
            InventoryContainer ic = null;
            if (this.world.rand.nextBoolean() && (ic = victim.getArmor(0)) != null) {
                victim.setArmor(0, null);
                this.spititout(ic);
            }
            if (this.world.rand.nextBoolean() && (ic = victim.getArmor(1)) != null) {
                victim.setArmor(1, null);
                this.spititout(ic);
            }
            if (this.world.rand.nextBoolean() && (ic = victim.getArmor(2)) != null) {
                victim.setArmor(2, null);
                this.spititout(ic);
            }
            if (this.world.rand.nextBoolean() && (ic = victim.getArmor(3)) != null) {
                victim.setArmor(3, null);
                this.spititout(ic);
            }
            if (this.world.rand.nextBoolean() && (ic = victim.getHotbar(victim.gethotbarindex())) != null) {
                victim.setHotbar(victim.gethotbarindex(), null);
                this.spititout(ic);
            }
        }
        super.doAttack(victim);
    }

    public void player_morph_update(float deltaT, Player pl) {
        long curtime = System.currentTimeMillis();
        double distdiff = Math.sqrt((this.posx - this.lposx[0]) * (this.posx - this.lposx[0]) + (this.posy - this.lposy[0]) * (this.posy - this.lposy[0]) + (this.posz - this.lposz[0]) * (this.posz - this.lposz[0]));
        double maxdiff = 1.0;
        long maxtime = 100L;
        if (this.isBaby()) {
            maxdiff = 0.25;
            maxtime = 25L;
        }
        this.posx = pl.posx;
        this.posy = pl.posy;
        this.posz = pl.posz;
        float derp = (float)Math.toDegrees(Math.atan2(-pl.motiony, Math.sqrt(pl.motionx * pl.motionx + pl.motionz * pl.motionz)));
        if (curtime - this.lasttime > maxtime || distdiff > maxdiff) {
            this.lasttime = curtime;
            int i = 99;
            while (i > 0) {
                this.lposx[i] = this.lposx[i - 1];
                this.lposy[i] = this.lposy[i - 1];
                this.lposz[i] = this.lposz[i - 1];
                this.rotpitch[i] = this.rotpitch[i - 1];
                this.rotroll[i] = this.rotroll[i - 1];
                this.rotyaw[i] = this.rotyaw[i - 1];
                --i;
            }
            this.lposx[0] = this.posx;
            this.lposy[0] = this.posy;
            this.lposz[0] = this.posz;
            this.rotpitch[0] = derp;
            this.rotroll[0] = this.display_rotation_roll;
            this.rotyaw[0] = this.display_rotation_yaw;
        }
    }

    public void update(float deltaT) {
        long curtime = System.currentTimeMillis();
        double distdiff = Math.sqrt((this.posx - this.lposx[0]) * (this.posx - this.lposx[0]) + (this.posy - this.lposy[0]) * (this.posy - this.lposy[0]) + (this.posz - this.lposz[0]) * (this.posz - this.lposz[0]));
        double maxdiff = 1.0;
        long maxtime = 100L;
        if (this.isBaby()) {
            maxdiff = 0.25;
            maxtime = 25L;
        }
        if (curtime - this.lasttime > maxtime || distdiff > maxdiff) {
            this.lasttime = curtime;
            int i = 99;
            while (i > 0) {
                this.lposx[i] = this.lposx[i - 1];
                this.lposy[i] = this.lposy[i - 1];
                this.lposz[i] = this.lposz[i - 1];
                this.rotpitch[i] = this.rotpitch[i - 1];
                this.rotroll[i] = this.rotroll[i - 1];
                this.rotyaw[i] = this.rotyaw[i - 1];
                --i;
            }
            this.lposx[0] = this.posx;
            this.lposy[0] = this.posy;
            this.lposz[0] = this.posz;
            this.rotpitch[0] = this.display_rotation_pitch;
            this.rotroll[0] = this.display_rotation_roll;
            this.rotyaw[0] = this.display_rotation_yaw;
        }
        super.update(deltaT);
    }

    public void doEntityAction(float deltaT) {
        EntityBlockItem e;
        int bid;
        float updown = 0.0f;
        float tdir = 0.0f;
        float myspeed = 0.75f;
        if (this.isBaby()) {
            myspeed = 0.55f;
        }
        this.motionx = (float)Math.sin(Math.toRadians(this.rotation_yaw)) * myspeed;
        this.motionz = (float)Math.cos(Math.toRadians(this.rotation_yaw)) * myspeed;
        int k = 0;
        int ht = 6;
        float frq = 10.0f;
        if (this.isBaby()) {
            ht = 3;
            frq = 20.0f;
        }
        k = ht;
        while (k >= -ht) {
            bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + k, (int)this.posz);
            if (bid != 0) break;
            --k;
        }
        updown = (float)Math.sin(Math.toRadians(this.getVarFloat(10) * frq)) * (float)ht;
        updown -= (float)k;
        updown = -updown;
        this.motiony *= 0.98f;
        this.motiony += 0.008f * updown;
        float dx = (float)Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz);
        float dz = (float)Math.atan2(-this.motiony, dx);
        this.rotation_pitch = (float)Math.toDegrees(dz);
        this.rotation_roll = 0.0f;
        this.setVarFloat(10, (this.getVarFloat(10) + 0.5f) % 360.0f);
        if (this.world.rand.nextInt(200) == 1) {
            Player p = DangerZone.server.findNearestPlayer((Entity)this);
            if (p != null) {
                float delta = 110.0f;
                InventoryContainer ic = p.getHotbar(p.gethotbarindex());
                if (ic != null && ic.iid == OreSpawnMain.wormfood.itemID) {
                    delta = 50.0f;
                }
                tdir = (float)Math.atan2(p.posx - this.posx, p.posz - this.posz);
                tdir = (float)Math.toDegrees(tdir);
                this.setVarFloat(11, (tdir += (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * delta) % 360.0f);
            } else {
                this.setVarFloat(11, this.world.rand.nextFloat() * 360.0f);
            }
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        tdir = (float)Math.toRadians(this.getVarFloat(11));
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion *= 0.95f;
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 20.0);
        int currentwidth = 3;
        int cury = (int)this.posy;
        int curx = (int)this.posx;
        int curz = (int)this.posz;
        if (this.isBaby()) {
            currentwidth = 1;
        }
        int da = 10;
        float currad = 0.0f;
        if (currentwidth < 4) {
            da = 15;
        }
        if (currentwidth > 6) {
            da = 5;
        }
        float dirang = (float)Math.toRadians(this.getVarFloat(10) - 90.0f);
        float dirax = (float)Math.cos(dirang);
        float diraz = (float)Math.sin(dirang);
        boolean canbreak = true;
        if (!DangerZone.playnicely && !DangerZone.freeze_world) {
            int j = 0;
            while (j < 360 && canbreak) {
                currad = 0.0f;
                float ty = (float)Math.sin(Math.toRadians(j));
                float tt = (float)Math.cos(Math.toRadians(j));
                float tx = dirax * tt;
                float tz = diraz * tt;
                while (currad < (float)currentwidth) {
                    if ((int)((float)cury + ty * (currad += 0.2f)) >= 0) {
                        bid = this.world.getblock(this.dimension, (int)((float)curx + tx * currad), (int)((float)cury + ty * currad), (int)((float)curz + tz * currad));
                        if (bid == 0) continue;
                        if (bid == Blocks.stopblock.blockID || bid == Blocks.hardrock.blockID || bid == Blocks.firestone.blockID || bid == OreSpawnMain.crystalstone.blockID) {
                            canbreak = false;
                            break;
                        }
                        if (bid == Blocks.water.blockID || bid == Blocks.waterstatic.blockID) {
                            canbreak = false;
                            break;
                        }
                        canbreak = this.world.setblocknonotifyWithPerm((Entity)this, this.dimension, (int)((float)curx + tx * currad), (int)((float)cury + ty * currad), (int)((float)curz + tz * currad), 0);
                        if (!canbreak) break;
                        if (this.world.rand.nextInt(10) != 1 || (e = (EntityBlockItem)this.world.createEntityByName(DangerZone.blockitemname, this.dimension, (double)((int)((float)curx + tx * currad)), (double)((int)((float)cury + ty * currad)), (double)((int)((float)curz + tz * currad)))) == null) continue;
                        e.init();
                        e.fill(bid, 0, 1);
                        e.rotation_pitch = this.world.rand.nextInt(360);
                        e.rotation_yaw = this.world.rand.nextInt(360);
                        e.rotation_roll = this.world.rand.nextInt(360);
                        e.motionx = this.world.rand.nextFloat() - this.world.rand.nextFloat();
                        e.motiony = this.world.rand.nextFloat() / 4.0f;
                        e.motionz = this.world.rand.nextFloat() - this.world.rand.nextFloat();
                        e.deathtimer = 200;
                        this.world.spawnEntityInWorld((Entity)e);
                        continue;
                    }
                    canbreak = false;
                    break;
                }
                j += da;
            }
        }
        if (!canbreak) {
            this.deadflag = true;
            int i = 0;
            while (i < 100) {
                if (i % 3 == 0) {
                    Explosion.boom((Entity)this, (World)this.world, (int)this.dimension, (double)this.lposx[i], (double)this.lposy[i], (double)this.lposz[i], (int)15, (boolean)true);
                }
                ++i;
            }
        }
        if (this.backoff > 0) {
            --this.backoff;
            this.inarow = 0;
        } else {
            Entity victim = this.findSomethingToAttack();
            if (victim != null) {
                tdir = (float)Math.atan2(victim.posx - this.posx, victim.posz - this.posz);
                this.setVarFloat(11, (float)Math.toDegrees(tdir));
                this.motiony = (float)((double)this.motiony + (victim.posy - this.posy) * (double)5.0E-4f);
                float ar = this.attackRange;
                if (this.isBaby()) {
                    ar /= 4.0f;
                }
                if (this.getDistanceFromEntity(victim) < (double)(ar + victim.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                    ++this.inarow;
                    if (this.inarow > 20) {
                        this.backoff = this.world.rand.nextInt(40);
                    }
                    if (this.world.rand.nextInt(4) == 1) {
                        victim.doAttackFrom((Entity)this, 4, this.getAttackDamage());
                    }
                }
            } else {
                e = this.findSomethingToEat();
                if (e != null) {
                    if (e.getDistanceFromEntity((Entity)this) < (double)(this.getWidth() / 2.0f + 2.0f)) {
                        e.deadflag = true;
                        this.doEatDroppedFood(e);
                    } else {
                        tdir = (float)Math.atan2(e.posx - this.posx, e.posz - this.posz);
                        this.setVarFloat(11, (float)Math.toDegrees(tdir));
                        this.motiony = (float)((double)this.motiony + (e.posy - this.posy) * (double)5.0E-4f);
                    }
                }
            }
        }
        if (this.world.rand.nextInt(5000) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggdoomworm.itemID, (float)0.1f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
    }

    private void spititout(InventoryContainer ic) {
        EntityBlockItem e = (EntityBlockItem)this.world.createEntityByName(DangerZone.blockitemname, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 4.0f), this.posy + 1.0, this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 4.0f));
        if (e != null) {
            e.fill(ic);
            e.rotation_pitch = this.world.rand.nextInt(360);
            e.rotation_yaw = this.world.rand.nextInt(360);
            e.rotation_roll = this.world.rand.nextInt(360);
            this.world.spawnEntityInWorld((Entity)e);
        }
    }

    public String getLivingSound() {
        int which = this.world.rand.nextInt(4);
        if (which == 0) {
            return "OreSpawn:caterkiller_living1";
        }
        if (which == 1) {
            return "OreSpawn:caterkiller_living2";
        }
        if (which == 2) {
            return "OreSpawn:caterkiller_living3";
        }
        return "OreSpawn:caterkiller_living4";
    }

    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    public void doDeathDrops() {
        int howmany = 40 + this.world.rand.nextInt(40);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 20 + this.world.rand.nextInt(20);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggdoomworm.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 20 + this.world.rand.nextInt(20);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)OreSpawnMain.oreamethyst.blockID, (int)0, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 20 + this.world.rand.nextInt(20);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)OreSpawnMain.oreruby.blockID, (int)0, (float)6.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 20 + this.world.rand.nextInt(20);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)OreSpawnMain.oretitanium.blockID, (int)0, (float)7.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 20 + this.world.rand.nextInt(20);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)OreSpawnMain.oreuranium.blockID, (int)0, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophydoomworm.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof DoomWorm) {
            return false;
        }
        if (e instanceof WormLarge) {
            return false;
        }
        if (e instanceof WormMedium) {
            return false;
        }
        if (e instanceof WormSmall) {
            return false;
        }
        InventoryContainer ic = e.getHotbar(e.gethotbarindex());
        if (ic != null) {
            if (ic.iid == OreSpawnMain.eggdoomworm.itemID) {
                return false;
            }
            if (ic.iid == OreSpawnMain.wormfood.itemID) {
                return false;
            }
        }
        if (e instanceof Player) {
            return true;
        }
        if (e instanceof Girlfriend) {
            return true;
        }
        return e.temperament == 1;
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/DoomWormtexture.png");
        }
        return this.texture;
    }

    public boolean isBoss() {
        return true;
    }

    public String getBossName() {
        return "Doom Worm!";
    }
}

